@echo off
chcp 65001 >nul 2>&1
title Calradia Online - Installer v1.2
color 0A

echo.
echo  =========================================================
echo            CALRADIA ONLINE - INSTALLER v1.2
echo  =========================================================
echo.

:: Проверка прав администратора
net session >nul 2>&1
if %errorLevel% neq 0 (
    color 0C
    echo  [ERROR] Administrator rights required!
    echo.
    echo  Right-click Install.bat and select "Run as administrator"
    echo.
    pause
    exit /b 1
)

:: Автопоиск Bannerlord через реестр Steam
set "BANNERLORD_PATH="

:: Попытка 1: Steam реестр (64-bit)
for /f "tokens=2*" %%a in ('reg query "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Steam App 261550" /v "InstallLocation" 2^>nul') do set "BANNERLORD_PATH=%%b"

:: Попытка 2: Steam реестр (32-bit на 64-bit Windows)
if not defined BANNERLORD_PATH for /f "tokens=2*" %%a in ('reg query "HKLM\SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall\Steam App 261550" /v "InstallLocation" 2^>nul') do set "BANNERLORD_PATH=%%b"

:: Попытка 3: Типичные пути Steam
if not defined BANNERLORD_PATH if exist "C:\Program Files (x86)\Steam\steamapps\common\Mount & Blade II Bannerlord\Modules" set "BANNERLORD_PATH=C:\Program Files (x86)\Steam\steamapps\common\Mount & Blade II Bannerlord"
if not defined BANNERLORD_PATH if exist "D:\Steam\steamapps\common\Mount & Blade II Bannerlord\Modules" set "BANNERLORD_PATH=D:\Steam\steamapps\common\Mount & Blade II Bannerlord"
if not defined BANNERLORD_PATH if exist "D:\SteamLibrary\steamapps\common\Mount & Blade II Bannerlord\Modules" set "BANNERLORD_PATH=D:\SteamLibrary\steamapps\common\Mount & Blade II Bannerlord"
if not defined BANNERLORD_PATH if exist "E:\SteamLibrary\steamapps\common\Mount & Blade II Bannerlord\Modules" set "BANNERLORD_PATH=E:\SteamLibrary\steamapps\common\Mount & Blade II Bannerlord"
if not defined BANNERLORD_PATH if exist "F:\SteamLibrary\steamapps\common\Mount & Blade II Bannerlord\Modules" set "BANNERLORD_PATH=F:\SteamLibrary\steamapps\common\Mount & Blade II Bannerlord"
if not defined BANNERLORD_PATH if exist "G:\SteamLibrary\steamapps\common\Mount & Blade II Bannerlord\Modules" set "BANNERLORD_PATH=G:\SteamLibrary\steamapps\common\Mount & Blade II Bannerlord"

:: Если не найден - запросить у пользователя
if not defined BANNERLORD_PATH (
    color 0E
    echo  [WARNING] Bannerlord not found automatically.
    echo.
    echo  Please enter the full path to your Bannerlord installation folder.
    echo  Example: D:\SteamLibrary\steamapps\common\Mount ^& Blade II Bannerlord
    echo.
    set /p "BANNERLORD_PATH=  Path: "
)

:: Убираем кавычки если пользователь их добавил
set "BANNERLORD_PATH=%BANNERLORD_PATH:"=%"

:: Валидация пути
if not exist "%BANNERLORD_PATH%\Modules" (
    color 0C
    echo.
    echo  [ERROR] Invalid path: Modules folder not found!
    echo.
    echo  Make sure you entered the correct Bannerlord installation path.
    echo  The path should contain a "Modules" folder.
    echo.
    pause
    exit /b 1
)

echo  [FOUND] %BANNERLORD_PATH%
echo.

:: Определяем путь назначения
set "DEST=%BANNERLORD_PATH%\Modules\HeadlessCampaignServer"

:: Удаляем старую установку если есть
if exist "%DEST%" (
    echo  [INFO] Removing previous installation...
    rmdir /s /q "%DEST%" 2>nul
    timeout /t 1 /nobreak >nul
)

:: Копирование файлов
echo  [COPY] Installing mod files...
xcopy /s /e /i /y "%~dp0HeadlessCampaignServer" "%DEST%" >nul 2>&1
if %errorLevel% neq 0 (
    color 0C
    echo  [ERROR] Failed to copy files!
    echo  Make sure the game is not running and try again.
    echo.
    pause
    exit /b 1
)
echo  [OK] Files copied successfully
echo.

:: Разблокировка DLL
echo  [UNLOCK] Unblocking DLL files...
powershell -ExecutionPolicy Bypass -Command "Get-ChildItem -Recurse '%DEST%' -Include *.dll | Unblock-File" 2>nul
if %errorLevel% neq 0 (
    echo  [WARN] PowerShell unblock may have failed, trying alternative...
    powershell -Command "Get-ChildItem -Recurse '%DEST%' | ForEach-Object { $_.Attributes = $_.Attributes -band (-bnot [System.IO.FileAttributes]::ReadOnly) }" 2>nul
)
echo  [OK] DLL files unblocked
echo.

:: Успех
color 0A
echo  =========================================================
echo              INSTALLATION COMPLETE!
echo  =========================================================
echo.
echo  Next steps:
echo    1. Launch Mount ^& Blade II Bannerlord
echo    2. In the Launcher, go to "Mods" and enable:
echo       - Native
echo       - SandBoxCore
echo       - Sandbox
echo       - Calradia Online
echo    3. Click "Play"
echo    4. In the main menu, click "Online Campaign"
echo    5. You will be connected to the server automatically
echo.
echo  Server: 159.203.92.147:7210 (auto-configured)
echo.
echo  ---------------------------------------------------------
echo  Installed to: %DEST%
echo  ---------------------------------------------------------
echo.
pause
